/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx_extensions.h"
#include "test_common.h"

#define ADDR_OF_PARTNER_1_FROM_ENDPOINT_2 "ADDR_OF_PARTNER_1_IN_ENDPOINT_2"
#define ADDR_OF_PARTNER_2_FROM_ENDPOINT_1 "ADDR_OF_PARTNER_2_IN_ENDPOINT_1"

int main(int argc, char **argv)
{
  mx_return_t r;
  mx_endpoint_t ep;
  mx_endpoint_t ep2;
  mx_endpoint_addr_t tmp_addr, addr1to2, addr2to1;
  uint64_t nic_id, nic_id2;
  uint32_t eid, eid2;
  mx_request_t send_req;
  mx_request_t recv_req;
  mx_status_t status;
  uint32_t result;
  void * context;

  r = mx_init();
  insist(r == MX_SUCCESS);

  r = mx_open_endpoint(MX_ANY_NIC, MX_ANY_ENDPOINT, 0, NULL, 0, &ep);
  insist(r == MX_SUCCESS);
  mx_get_endpoint_addr(ep, &tmp_addr);
  mx_decompose_endpoint_addr(tmp_addr, &nic_id, &eid);

  r = mx_open_endpoint(MX_ANY_NIC, MX_ANY_ENDPOINT, 0, NULL, 0, &ep2);
  insist(r == MX_SUCCESS);
  mx_get_endpoint_addr(ep2, &tmp_addr);
  mx_decompose_endpoint_addr(tmp_addr, &nic_id2, &eid2);

  r = mx_connect(ep, nic_id2, eid2, 0, MX_INFINITE, &addr1to2);
  insist(r == MX_SUCCESS);
  r = mx_connect(ep2, nic_id, eid, 0, MX_INFINITE, &addr2to1);
  insist(r == MX_SUCCESS);

  mx_get_endpoint_addr_context(addr1to2, &context);
  insist(!context);
  mx_get_endpoint_addr_context(addr2to1, &context);
  insist(!context);
  printf("endpoint address are initially NULL\n");

  mx_set_endpoint_addr_context(addr1to2, ADDR_OF_PARTNER_2_FROM_ENDPOINT_1);
  printf("setting endpoint address from 1 to 2 context to " ADDR_OF_PARTNER_2_FROM_ENDPOINT_1 "\n");
  mx_set_endpoint_addr_context(addr2to1, ADDR_OF_PARTNER_1_FROM_ENDPOINT_2);
  printf("setting endpoint address from 2 to 1 context to " ADDR_OF_PARTNER_1_FROM_ENDPOINT_2 "\n");

  printf("posting receive on 2\n");
  r = mx_irecv(ep2, NULL, 0, 0, 0, NULL, &recv_req);
  insist(r == MX_SUCCESS);
  printf("posting send on 1 to 2\n");
  r = mx_isend(ep, NULL, 0, addr1to2, 0, NULL, &send_req);
  insist(r == MX_SUCCESS);
  r = mx_wait(ep, &send_req, MX_INFINITE, &status, &result);
  insist(r == MX_SUCCESS && result);
  r = mx_wait(ep2, &recv_req, MX_INFINITE, &status, &result);
  insist(r == MX_SUCCESS && result);
  mx_get_endpoint_addr_context(status.source, &context);
  printf("address context is %s\n", (char*) context);
  insist(!strcmp(ADDR_OF_PARTNER_1_FROM_ENDPOINT_2, (char*) context));

  printf("posting receive on 1\n");
  r = mx_irecv(ep, NULL, 0, 0, 0, NULL, &recv_req);
  insist(r == MX_SUCCESS);
  printf("posting send on 2 to 1\n");
  r = mx_isend(ep2, NULL, 0, addr2to1, 0, NULL, &send_req);
  insist(r == MX_SUCCESS);
  r = mx_wait(ep2, &send_req, MX_INFINITE, &status, &result);
  insist(r == MX_SUCCESS && result);
  r = mx_wait(ep, &recv_req, MX_INFINITE, &status, &result);
  insist(r == MX_SUCCESS && result);
  mx_get_endpoint_addr_context(status.source, &context);
  printf("address context is %s\n", (char*) context);
  insist(!strcmp(ADDR_OF_PARTNER_2_FROM_ENDPOINT_1, (char*) context));

  mx_close_endpoint(ep);
  mx_close_endpoint(ep2);
  mx_finalize();

  return 0;
}
